/*
 * Decompiled with CFR 0.152.
 */
package com.annimon;

import java.io.DataOutputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Image;

public class BMP_Writer {
    private byte[] bfType = new byte[]{66, 77};
    private int biWidth = 0;
    private int padWidth = 0;
    private int biHeight = 0;
    private int[] intBitmap;
    private OutputStream fo;
    private DataOutputStream bfo;
    private Image imp;

    public void run(Image image, String path) throws Exception {
        this.imp = image;
        this.writeImage(path);
    }

    private void writeImage(String path) throws Exception {
        FileConnection fc = (FileConnection)Connector.open((String)(path + ".bmp"), (int)3);
        fc.create();
        this.fo = fc.openOutputStream();
        this.bfo = new DataOutputStream(this.fo);
        this.convertImage(this.imp.getWidth(), this.imp.getHeight());
        this.writeBitmapFileHeader();
        this.writeBitmapInfoHeader();
        this.writeBitmap();
        this.bfo.close();
        this.fo.close();
        fc.close();
    }

    private void convertImage(int parWidth, int parHeight) {
        this.intBitmap = new int[this.imp.getWidth() * this.imp.getHeight()];
        this.imp.getRGB(this.intBitmap, 0, this.imp.getWidth(), 0, 0, this.imp.getWidth(), this.imp.getHeight());
        this.biWidth = parWidth;
        this.biHeight = parHeight;
        int pad = 4 - this.biWidth * 3 % 4;
        if (pad == 4) {
            pad = 0;
        }
        this.padWidth = this.biWidth * 3 + pad;
    }

    private void writeBitmap() throws Exception {
        byte[] rgb = new byte[3];
        int pad = 4 - this.biWidth * 3 % 4;
        if (pad == 4) {
            pad = 0;
        }
        int counter = 0;
        for (int row = this.biHeight; row > 0; --row) {
            for (int col = 0; col < this.biWidth; ++col) {
                int value = this.intBitmap[(row - 1) * this.biWidth + col];
                rgb[0] = (byte)(value & 0xFF);
                rgb[1] = (byte)(value >> 8 & 0xFF);
                rgb[2] = (byte)(value >> 16 & 0xFF);
                ((OutputStream)this.bfo).write(rgb);
                ++counter;
            }
            for (int i = 1; i <= pad; ++i) {
                this.bfo.write(0);
            }
            counter += pad;
        }
    }

    private void writeBitmapFileHeader() throws Exception {
        this.fo.write(this.bfType);
        int bfSize = 54 + this.padWidth * this.biHeight;
        this.fo.write(this.intToDWord(bfSize));
        this.fo.write(this.intToWord(0));
        this.fo.write(this.intToWord(0));
        this.fo.write(this.intToDWord(54));
    }

    private void writeBitmapInfoHeader() throws Exception {
        this.fo.write(this.intToDWord(40));
        this.fo.write(this.intToDWord(this.biWidth));
        this.fo.write(this.intToDWord(this.biHeight));
        this.fo.write(this.intToWord(1));
        this.fo.write(this.intToWord(24));
        this.fo.write(this.intToDWord(0));
        this.fo.write(this.intToDWord(0));
        this.fo.write(this.intToDWord(0));
        this.fo.write(this.intToDWord(0));
        this.fo.write(this.intToDWord(0));
        this.fo.write(this.intToDWord(0));
    }

    private byte[] intToWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
        return retValue;
    }

    private byte[] intToDWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
        return retValue;
    }
}

